function bmean=estimate_VAR_mean_c(bolsvec,Y,L,REPS,y,x)
%VAR estimates with bootstrap bias correction
N=cols(Y);
T=rows(Y);
bols=reshape(bolsvec,N*L+1,N);
resid=y-x*bols;
%starting values
history=cell(T,1);
for t=1:L
    history{t}=Y(1:L,:);
end
for t=L+1:T
    tmp=Y(t-L+1:t,:);
    history{t}=tmp;
end

%bootstrap
bsave=zeros(REPS,N*L+1,N);
for r=1:REPS
    
    %re-sample resids
    id=randsample(T,T+L,true);
    residb=resid(id,:);
    %random start
    ids=randsample(T,1,true);
    start=history{ids};
    
    Yb=zeros(T+L,N);
    Yb(1:L,:)=start;
    for t=L+1:T+L
    Xb=zeros(1,N*L);
    jj=1;
    for j=1:L
        Xb(:,jj:jj+N-1)=Yb(t-j,:);
        jj=jj+N;
    end
    Yb(t,:)=[Xb 1]*bols+residb(t,:);
    end
  
    %OLS estimation on bootstrap data
    data=Yb;
    xx=prepare(data,L);
    yy=data(L+1:end,:);
    xx=xx(L+1:end,:);
    bols_b=xx\yy;
    bsave(r,:,:)=bols_b;
end
%bias
bmean=vec(squeeze(mean(bsave)));
